#ifdef GL_ES
precision mediump float;

varying vec2 vTexCoord;

vec4 fragColor;
#else
in vec2 vTexCoord;
out vec4 gl_FragColor;
#endif
uniform sampler2D normalTex;
uniform vec4 inColor;

void main()
{
#ifdef GL_ES
    vec3 bump = normalize(texture2D(normalTex, vTexCoord.st).xyz * 2.0 - 1.0);
#else
    vec3 bump = normalize(texture(normalTex, vTexCoord.st).xyz * 2.0 - 1.0);
#endif

	/* red book p. 223 */
	vec3 diffuse = inColor.rgb * bump.b;
	
	fragColor = vec4(diffuse, 1.0);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
